﻿using System;
using System.Collections;
using System.Configuration;
using System.Data;
using System.Linq;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Xml.Linq;
using DataAccess;
using ext = Ext.Net;

public partial class reset_password : System.Web.UI.Page
{
    /// <summary>
    /// US:6971 loads the change password page
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack) {
            if (!ext.X.IsAjaxRequest) {
                Session.Remove("FX_USER_ID");
                htxtResetStage.Text = "0";
            }
        }
    }

    [ext.DirectMethod(ShowMask = true, Msg = "Please wait.")]
    /// <summary>
    /// US:6971 challenges the user to answer security question in order to proceed to the password reset,
    /// if it is a first-time login, user is then asked to select their security challenge questions and 
    /// the corresponding answer for each
    /// </summary>
    public void Submit_Click()
    {
        CSec sec = new CSec();
        CSecQuestions secquest = new CSecQuestions(Master);

        #region ShowUserName
        //if (!pnlAccntDetails.Hidden)
        if (htxtResetStage.Text.Equals("0"))
        {

            Session["FX_USER_ID"] = null;
            bool bIsLocked = false;
            bool bIPLocked = false;

            if (txtUserName.Text.Trim().Length < 1)
            {
                return;
            }

            string strUsername = sec.Enc(txtUserName.Text.Trim(), String.Empty);

            DataSet dsQuest = secquest.GetUserQuestions(strUsername);

            if (dsQuest != null)
            {
                foreach (DataTable dt in dsQuest.Tables)
                {
                    foreach (DataRow dr in dt.Rows)
                    {
                        if (!dr.IsNull("QUESTION_1"))
                        {
                            lblQuestion1.Text = dr["QUESTION_1"].ToString();
                            txtAnswer1.Text = String.Empty;
                        }

                        if (!dr.IsNull("QUESTION_2"))
                        {
                            lblQuestion2.Text = dr["QUESTION_2"].ToString();
                            txtAnswer2.Text = String.Empty;
                        }

                        //if (!dr.IsNull("QUESTION_3"))
                        //{
                        //    lblQuestion3.Text = dr["QUESTION_3"].ToString();
                        //    txtAnswer3.Text = String.Empty;
                        //}

                        if (!dr.IsNull("FX_USER_ID"))
                        {
                            Session["FX_USER_ID"] = Convert.ToInt32(dr["FX_USER_ID"]);
                        }

                        if (!dr.IsNull("IS_LOCKED"))
                        {
                            bIsLocked = Convert.ToInt32(dr["IS_LOCKED"]) == 1;
                        }

                        if (!dr.IsNull("IP_LOCKED"))
                        {
                            bIPLocked = Convert.ToInt32(dr["IP_LOCKED"]) == 1;
                        }
                    }
                }

                if (dsQuest.Tables[0].Rows.Count > 0)
                {
                    if (!bIsLocked)
                    {
                        bool bConfirmedAccnt = true;

                        if (Convert.ToInt32(Session["FX_USER_ID"]) == 0)
                        {
                            Master.StatusCode = 1;
                            Master.StatusComment = "The Username you entered is incorrect.";
                            bConfirmedAccnt = false;
                        }
                        else if (Convert.ToInt32(Session["FX_USER_ID"]) > 0
                            && (lblQuestion1.Text.Length < 1 ||
                            lblQuestion2.Text.Length < 1))
                        {
                            Master.StatusCode = 1;
                            Master.StatusComment = "You have not yet selected security questions for your portal account.";
                            bConfirmedAccnt = false;
                        }

                        if (bConfirmedAccnt)
                        {
                            htxtResetStage.Text = "1";
                            pnlAccntDetails.Hide();
                            pnlSecQuestions.Show();
                        }
                        else
                        {
                            htxtResetStage.Text = "0";
                            pnlAccntDetails.Show();
                            pnlSecQuestions.Hide();
                            ShowSysFeedback();
                        }
                    }
                    else
                    {
                        htxtResetStage.Text = "0";
                        pnlAccntDetails.Show();
                        pnlSecQuestions.Hide();

                        Master.StatusCode = 9; //9: account is locked
                        Master.StatusComment = "Your account has been locked. Please contact the system administrator to reactivate your login.";
                        
                        ShowSysFeedback();
                    }
                }
                else
                {
                    Master.StatusCode = 1;
                    Master.StatusComment = "The Username you entered is incorrect.";

                    ShowSysFeedback();
                }
            }
            else
            {
                ShowSysFeedback();
                return;
            }
        }
        #endregion
        #region ShowSecQuestions
        //else if (!pnlSecQuestions.Hidden)
        else if (htxtResetStage.Text.Equals("1"))
        {

            ///long lValidate = 0;
            long lFXUserID = 0;

            if (txtAnswer1.Text.Trim().Length > 0
                && txtAnswer2.Text.Trim().Length > 0)
            {
                if (Session["FX_USER_ID"] != null)
                {
                    lFXUserID = Convert.ToInt32(Session["FX_USER_ID"]);
                }

                string strAnswer1 = sec.Enc(txtAnswer1.Text.Trim().ToLower(), String.Empty);
                string strAnswer2 = sec.Enc(txtAnswer2.Text.Trim().ToLower(), String.Empty);
                secquest.ValidateAnswers(lFXUserID, strAnswer1, strAnswer2, String.Empty);

                if (Master.StatusCode == 0) // good to continue to reset password
                {
                    htxtResetStage.Text = "2";
                    pnlSecQuestions.Hide();
                    pnlNewPassword.Show();
                }
                else if (Master.StatusCode == 1) //1: invalid answer
                {
                    ShowSysFeedback();
                }
                else if (Master.StatusCode == 9) //9: account is locked
                {
                    btnSubmit.Hide();
                    lblAccLocked.Text = Master.StatusComment;
                    lblAccLocked.Show();
                }
            }
            else
            {
                Master.StatusCode = 1;
                Master.StatusComment = "Please answer all the questions to continue.";
                ShowSysFeedback();
            }
        }
        #endregion
        #region ShowNewPassword
        //else if (!pnlNewPassword.Hidden)
        else if (htxtResetStage.Text.Equals("2"))
        {
            if (txtPassword.Text.Trim().Length < 1 || txtConfirmPassword.Text.Trim().Length < 1)
            {
                Master.StatusCode = 1;
                Master.StatusComment = "Pasword and Password Confirmation are required.";
                ShowSysFeedback();
                return;
            }
            
            if (txtPassword.Text.Trim() != txtConfirmPassword.Text.Trim()) {
                Master.StatusCode = 1;
                Master.StatusComment = "Pasword and Password Confirmation are different.";
                ShowSysFeedback();
                return;
            }
            
            //change password and login
            long lFXUserID = 0;
            if (Session["FX_USER_ID"] != null)
            {
                lFXUserID = Convert.ToInt32(Session["FX_USER_ID"]);
            }

            string strUserName = txtUserName.Text.Trim();
            if (sec.ValidatePasswordRules(Master, txtPassword.Text.Trim()))
            {
                if (secquest.ResetPassword(lFXUserID, strUserName, txtPassword.Text.Trim()))
                {
                    long lStatusCode = 0;
                    string strStatusComment = String.Empty;

                    if (sec.Login(Master, txtUserName.Text.Trim(), txtPassword.Text.Trim()) != 0)
                    {
                        Master.StatusCode = lStatusCode;
                        Master.StatusComment = strStatusComment;
                        ShowSysFeedback();
                        return;
                    }

                    //set a session variable with the login time
                    Session["SESSION_INITIATED"] = DateTime.Now;

                    CPatient pat = new CPatient(Master);
                    CDataUtils utils = new CDataUtils();
                    DataSet dsPat = pat.GetPatientIDRS(Master.FXUserID);
                    Master.SelectedPatientID = utils.GetDSStringValue(dsPat, "PATIENT_ID");

                    //redirect, we are now logged in
                    Master.Response.Redirect("portal_start.aspx");

                    return;
                }
            }
        }
        #endregion

        ShowSysFeedback();
    }

    protected void ShowSysFeedback()
    {
        if (Master.StatusCode > 0 && !String.IsNullOrEmpty(Master.StatusComment))
        {
            Master.ShowSystemFeedback(Master.StatusComment, String.Empty);
            Master.ClearStatus();
        }
    }

}